# Shopify Integration - Installation Guide for Hosting

## 📦 Installation Options

You have **2 ways** to install the Shopify integration on your hosting:

---

## Option 1: Automatic (Recommended) ✅

When you upload your files to hosting, Laravel should automatically run migrations during the installation process.

**Steps:**
1. Upload all files to your hosting via FTP/cPanel
2. The installation script should detect new migrations
3. Tables will be created automatically
4. Done! ✅

**How to verify:**
- Check your database in phpMyAdmin
- Look for these new tables:
  - `ext_shopify_stores`
  - `ext_shopify_products`
  - `ext_shopify_orders`
  - `ext_campaign_conversions`

---

## Option 2: Manual SQL Import (If migrations don't run) 📝

If the automatic migrations don't run, you can manually import the SQL file:

**Steps:**

### 1. Open phpMyAdmin
- Log into your hosting control panel (cPanel)
- Click on **phpMyAdmin**

### 2. Select Your Database
- Click on your Laravel database name in the left sidebar

### 3. Import SQL File
- Click the **"Import"** tab at the top
- Click **"Choose File"**
- Select: `database/shopify_integration.sql`
- Click **"Go"** at the bottom

### 4. Verify Tables Created
- Check the left sidebar
- You should see 4 new tables starting with `ext_shopify_`

---

## 🎯 After Installation

Once the tables are created (either way), you can:

1. **Navigate to Marketing Dashboard**
2. **Go to Shopify Settings**
   - URL: `yourdomain.com/dashboard/user/marketing-bot/shopify/settings`
3. **Connect Your Shopify Store**
   - Enter shop domain
   - Enter API access token
   - Click "Connect Store"

---

## 📋 SQL File Location

The SQL file is located at:
```
database/shopify_integration.sql
```

This file contains all 4 tables needed for Shopify integration.

---

## ✅ What Gets Created

### Tables:
1. **ext_shopify_stores** - Store connection details
2. **ext_shopify_products** - Synced products from Shopify
3. **ext_shopify_orders** - Order data with UTM tracking
4. **ext_campaign_conversions** - Campaign ROI tracking

### Routes (Already Added):
- ✅ `/dashboard/user/marketing-bot/shopify/settings`
- ✅ `/dashboard/user/marketing-bot/shopify/connect`
- ✅ `/dashboard/user/marketing-bot/shopify/sync`

---

## 🆘 Troubleshooting

### If tables don't appear:
1. Check phpMyAdmin for errors
2. Verify database user has CREATE TABLE permissions
3. Try importing SQL file manually (Option 2)

### If routes don't work:
1. Clear Laravel cache: `php artisan config:clear`
2. Clear route cache: `php artisan route:clear`
3. Check `.htaccess` file exists

### If connection fails:
1. Verify Shopify API credentials
2. Check shop domain format (must be `yourstore.myshopify.com`)
3. Ensure API scopes are configured correctly

---

## 🎊 You're All Set!

Once installed, the Shopify integration will automatically:
- ✅ Sync products and orders
- ✅ Display daily analytics
- ✅ Track campaign ROI
- ✅ Show revenue trends
- ✅ Display top products

No additional configuration needed! 🚀
